function mpk = mpk_prm(k,t)

    %mpk is a 1*T vector
    %k is a 1*T vector
    %t is a 1*T vector
    %%Note: I need to adjust this to account for situations in which automation technologies are not adopted...

    global eeta_f eeta_0 aalpha_0 aalpha_f aalpha_rate A_rate Lwtd_0 ell_z psi_L A_neutral_0 A_neutral_f time_path eeta_rate h start_year finish_year



if t==-1        % At time -1 the parameters should have the values for the old steady state
    alpha=aalpha_0';
    gamma=eeta_0;
    A = A_neutral_0;
    
elseif 0<=t 
    
    if strcmpi(time_path, 'exponential')
        
    alpha    = aalpha_0'*exp(-aalpha_rate*(t+0.001))+aalpha_f'*(1-exp(-aalpha_rate*(t+0.001))); % the +0.001 here is needed to recreate an instantenous shock at t=0 when aalpha_rate = inf.
    gamma    = eeta_0*exp(-eeta_rate*(t+0.001))+eeta_f*(1-exp(-eeta_rate*(t+0.001)));
    A        = A_neutral_0'*exp(-A_rate*(t+0.001))+A_neutral_f'*(1-exp(-A_rate*(t+0.001)));
    
    elseif strcmpi(time_path, 'linear')
        
         if (t<=finish_year-start_year)  
            slope_aalpha = (aalpha_f - aalpha_0)/(finish_year-start_year);
            slope_eeta = (eeta_f - eeta_0)/(finish_year-start_year);
            slope_A      = (A_neutral_f - A_neutral_0)/(finish_year-start_year);
            
            alpha    = (aalpha_0 + slope_aalpha*t)';
            gamma    = eeta_0 + slope_eeta*t;
            A = A_neutral_0 + slope_A*t;
            
         elseif t>finish_year-start_year     
            alpha = aalpha_f';
            gamma = eeta_f;
            A     = A_neutral_f;
         end    
         
         
         
            elseif strcmpi(time_path, 'smoothed_linear')
            
             
            
            period = finish_year-start_year;
            
            slope_aalpha = (aalpha_f - aalpha_0)/(finish_year-start_year);
            slope_eeta = (eeta_f - eeta_0)/(finish_year-start_year);
            slope_A      = (A_neutral_f - A_neutral_0)/(finish_year-start_year);
            
            if (t<=finish_year-h-start_year) 
             
            alpha    = (aalpha_0 + slope_aalpha*t)';
            gamma    = eeta_0 + slope_eeta*t;
            A        = A_neutral_0 + slope_A*t;
            
            elseif t>finish_year-h-start_year && t<finish_year+h-start_year 
                
            alpha    = (aalpha_f + slope_aalpha*(-(t - h - period)^2/(4*h)))';
            gamma    = eeta_f + slope_eeta*(-(t - h - period)^2/(4*h));
            A        = A_neutral_f + slope_A*(-(t - h - period)^2/(4*h));
            
            elseif t>finish_year+h-start_year     
            alpha    = aalpha_f';
            gamma    = eeta_f;
            A        = A_neutral_f;
            end
            
    end
 


    if t~=-1
        alpha_k=eeta_f*alpha;
        mpk=alpha_k.*A.*(k./alpha_k).^alpha_k.*prod((psi_L.*ell_z./(eeta_f.*(1-alpha'))).^(eeta_f.*(1-alpha')),2)'./k;
    else
        alpha_k=aalpha_0*eeta_0';
        mpk=alpha_k.*A.*(k./alpha_k).^alpha_k.*Lwtd_0./k;
    end
    
    
end