% -------------------------------------------------------------------------
%
% Project: Uneven Growth
%
% Purpose: Create Figures 17, 18, 19 and appendix figures
%
% -------------------------------------------------------------------------

clear variables
close all

cd('C:/Users/Pascual Restrepo/Dropbox/Research/wealth_inequality/AutomationInequality/replication_mrr_january_2021/measuring_returns/')
addpath 'C:/Users/Pascual Restrepo/Documents/MATLAB/scripts'
addpath 'clean_data'
addpath 'output'

% -------------------------------------------------------------------------
%% - Preamble -
% -------------------------------------------------------------------------
 
% Set latex as default interpreter
set(groot, 'defaulttextinterpreter','latex'); 
set(groot, 'defaultAxesTickLabelInterpreter','latex'); 
set(groot, 'defaultLegendInterpreter','latex');


% -------------------------------------------------------------------------
%% - Read data -
% -------------------------------------------------------------------------

D = readtable("nipa_ima_clean.csv");

% -------------------------------------------------------------------------
%% - Figure XX - Returns to different assets in the US --------------------
% -------------------------------------------------------------------------

figure_17 = figure('units','centimeters','position',[10 10 12*(15/9) 10],'Color','w');

hold on
plot(D.year,D.ret_corp, 'r--','LineWidth',1.2);
message = sprintf('Corporate \nsector (IMA/NIPA)');
text(2017,1.05*D.ret_corp(end),message, 'color', 'r');

plot(D.year,D.ret_noncorp, 'r-', 'LineWidth',1.2);
message = sprintf('Noncorporate \nsector (IMA/NIPA)');
text(2017,D.ret_noncorp(end),message, 'color', 'r');

plot(D.year,D.ret_grr,'k-', 'LineWidth',1.2);
message = sprintf('Business capital \n(GRR)');
text(2017,D.ret_grr(end),message,'color', 'k');

plot(D.year,D.r_star,'b-' , 'LineWidth',1.2);
message = sprintf('Estimated $r^*$  \n (HLW)');
text(2017,D.r_star(end),message,'color', 'b');

ylabel('annual returns, percent')
title('Return measures for US capital')
xlim([1960, 2029])
ylim([-1 11])
set(gca,'ytick',0:2:10)
set(gcf, 'Color', 'w');
  
export_fig 'output/Figure_paper_returns'.pdf


% -------------------------------------------------------------------------
%% - Figure XX -Components of returns--------------------------------------
% -------------------------------------------------------------------------

figure_components = figure('units','centimeters','position',[10 10 7*(16/9)*2 10],'Color','w');
 
% - Panel.A Income based -
subplot(1,2,1)

hold on
plot(D.year,D.ret_corp, 'r--', 'LineWidth',1.2);
message = sprintf('corporate \nsector \n(IMA/NIPA)');
text(2017,D.ret_corp(end),message, 'color', 'r');

plot(D.year,D.ret_noncorp, 'r-', 'LineWidth',1.2);
message = sprintf('Noncorporate \nsector \n(IMA/NIPA)');
text(2017,D.ret_noncorp(end),message, 'color', 'r');

plot(D.year,D.ret_grr,'k-', 'LineWidth', 1.2);
message = sprintf('business \ncapital \n(GRR)');
text(2017,D.ret_grr(end),message,'color', 'k');

ylabel('annual returns, percent')
title('Panel A. income component')
ylim([3 11])
xlim([1960, 2030])
set(gca,'ytick',3:1:11,'xtick',1960:10:2020)

 
% - Panel.B Revaluations - 
subplot(1,2,2)
hold on
plot(D.year,D.rev_corp, 'r--', 'LineWidth',1);
message = sprintf('corporate \nsector (IMA/NIPA)');
text(1967,-15,message, 'color', 'r');

plot(D.year,D.rev_noncorp, 'r-', 'LineWidth',1);
message = sprintf('noncorporate \nsector (IMA/NIPA)');
text(1967,13,message, 'color', 'r');

plot(D.year,D.rev_grr, 'k-', 'LineWidth',1.2);
message = sprintf('business \ncapital \n(GRR)');
text(2017,D.rev_grr(end),message,'color', 'k');


ylabel('annual returns, percent')
title('Panel B. revaluation component')
xlim([1960, 2030])
set(gca,'ytick',-25:5:15,'xtick',1960:10:2020)
 
export_fig output/Figure_paper_returns_composition.pdf

% -------------------------------------------------------------------------
%% - Figure XX - Empirical estimates of returns----------------------------
% -------------------------------------------------------------------------

figure_19 = figure('units','centimeters','position',[10 10 7*(16/9)*2 10],'Color','w');

subplot(1,3,1)
hold on
h1=plot(D.year,D.rw_dina,  'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_top1,  'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa,   'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_top1, 'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima,  'b--',  'LineWidth', 1.2);
h6=xline(2007, '--', 'color', [0 0 0]+1/3 );
legend([h5 h1 h2 h3 h4],{'IMA', 'DINA', 'DINA top 1\%', 'DFA', 'DFA top 1\%'}, 'location', 'southwest');
ylabel('annual returns, percent')
title('Return to wealth $\hat{r}_W$')
xlim([1960, 2020]) 


subplot(1,3,2)
hold on
h1=plot(D.year,D.rw_dina_adj1, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_adj1_top1,    'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_adj1,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_adj1_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_adj1,   'b--',  'LineWidth', 1.2);
ylabel('return premium, percent')
title('Return premium, $\sigma=1$')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )


subplot(1,3,3)
hold on
h1=plot(D.year,D.rw_dina_adj2, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_adj2_top1,   'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_adj2,   'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_adj2_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_adj2,  'b--',  'LineWidth', 1.2);
ylabel('premium, percent')
title('Return premium, $\sigma=2$')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )

export_fig 'output/Figure_returns_wealth'.pdf


% -------------------------------------------------------------------------
%% - Figure 19 with constant pension shares-
% -------------------------------------------------------------------------

figure_19_cp = figure('units','centimeters','position',[10 10 7*(16/9)*2 10],'Color','w');

subplot(1,3,1)
hold on
h1=plot(D.year,D.rw_dina_cp, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_cp_top1,  'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_cp,   'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_cp_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_cp,   'b--',  'LineWidth', 1.2);
h6=xline(2007, '--', 'color', [0 0 0]+1/3 );
legend([h5 h1 h2 h3 h4],{'IMA', 'DINA', 'DINA top 1\%', 'DFA', 'DFA top 1\%'}, 'location', 'northwest');
ylabel('annual returns, percent')
title('Return to wealth $\hat{r}_W$')
xlim([1960, 2020]) 


subplot(1,3,2)
hold on
h1=plot(D.year,D.rw_dina_adj1_cp, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_adj1_cp_top1,   'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_adj1_cp,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_adj1_cp_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_adj1_cp,   'b--',  'LineWidth', 1.2);
ylabel('premium, percent')
title('Return premium, $\sigma=1$')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )


subplot(1,3,3)
hold on
h1=plot(D.year,D.rw_dina_adj2_cp, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_adj2_cp_top1,   'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_adj2_cp,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_adj2_cp_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_adj2_cp,   'b--',  'LineWidth', 1.2);
ylabel('premium, percent')
title('Return premium, $\sigma=2$')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )

export_fig 'output/Figure_returns_wealth_cp'.pdf



% -------------------------------------------------------------------------
%% - Figure 19 without pension shares-
% -------------------------------------------------------------------------

figure_19_np = figure('units','centimeters','position',[10 10 7*(16/9)*2 10],'Color','w');

subplot(1,3,1)
hold on
h1=plot(D.year,D.rw_dina_np, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_np_top1,  'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_np,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_np_top1, 'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_np,   'b--',  'LineWidth', 1.2);
h6=xline(2007, '--', 'color', [0 0 0]+1/3 );
legend([h5 h1 h2 h3 h4],{'IMA', 'DINA', 'DINA top 1\%', 'DFA', 'DFA top 1\%'}, 'location', 'northwest');
ylabel('annual returns, percent')
title('Return to wealth $\hat{r}_W$')
xlim([1960, 2020]) 
%ylim([2 9])


subplot(1,3,2)
hold on
h1=plot(D.year,D.rw_dina_adj1_np,  'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_adj1_np_top1,   'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_adj1_np,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_adj1_np_top1, 'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_adj1_np,   'b--',  'LineWidth', 1.2);
ylabel('premium, percent')
title('Return premium, $\sigma=1$')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )


subplot(1,3,3)
hold on
h1=plot(D.year,D.rw_dina_adj2_np,  'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.rw_dina_adj2_np_top1,   'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.rw_dfa_adj2_np,   'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.rw_dfa_adj2_np_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.rw_ima_adj2_np,   'b--',  'LineWidth', 1.2);
ylabel('premium, percent')
title('Return premium, $\sigma=2$')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )

export_fig 'output/Figure_returns_wealth_np'.pdf


% -------------------------------------------------------------------------
%% - Figure G.XX -
% -------------------------------------------------------------------------

figure_G_xx = figure('units','centimeters','position',[10 10 7*(16/9)*2 10],'Color','w');

subplot(1,3,1)
hold on
h1=plot(D.year,D.dina_eqsh,  'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.dina_eqsh_top1,   'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.dfa_eqsh,   'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.dfa_eqsh_top1,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.ima_eqsh,   'b--',  'LineWidth', 1.2);
h6=xline(2007, '--', 'color', [0 0 0]+1/3 );
ylabel('equity share of financial wealth, percent')
title('baseline')
xlim([1960, 2020]) 
ylim([20 80])


subplot(1,3,2)
hold on
h1=plot(D.year,D.dina_eqsh_cp,  'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.dina_eqsh_top1_cp,    'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.dfa_eqsh_cp,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.dfa_eqsh_top1_cp,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.ima_eqsh_cp,   'b--',  'LineWidth', 1.2);
h6=xline(2007, '--', 'color', [0 0 0]+1/3 );
legend([h5 h1 h2 h3 h4],{'IMA', 'DINA', 'DINA top 1\%', 'DFA', 'DFA top 1\%'}, 'location', 'northwest');
ylabel('equity share of financial wealth, percent')
title('constant pension share')
xlim([1960, 2020])



subplot(1,3,3)
hold on
h1=plot(D.year,D.dina_eqsh_np, 'r--',  'LineWidth', 1.2);
h2=plot(D.year,D.dina_eqsh_top1_np,  'r-',  'LineWidth', 1.2);
h3=plot(D.year,D.dfa_eqsh_np,  'k--',  'LineWidth', 1.2);
h4=plot(D.year,D.dfa_eqsh_top1_np,  'k-', 'LineWidth', 1.2);
h5=plot(D.year,D.ima_eqsh_np,  'b--',  'LineWidth', 1.2);
ylabel('equity share of financial wealth, percent')
title('excluding pension wealth')
xlim([1960, 2020])
xline(2007, '--', 'color', [0 0 0]+1/3 )

export_fig 'output/Figure_equity_shares'.pdf

