% -------------------------------------------------------------------------
%
% Project: Uneven Growth
%
% Purpose: Create Figure 9
%
% -------------------------------------------------------------------------

clear variables
close all

cd('C:/Users/Pascual Restrepo/Dropbox/Research/wealth_inequality/AutomationInequality/replication_mrr_january_2021/additional_evidence/psz_irs_data/')
addpath 'C:/Users/Pascual Restrepo/Documents/MATLAB/scripts'
addpath 'output'

% -------------------------------------------------------------------------
%% - Preamble -
% -------------------------------------------------------------------------

% Color choices %
lightBlue = [40, 100, 150] / 255 ;
alpha=0.6;
scorp_color=([0.4660, 0.6740, 0.1880])*alpha+(1-alpha)*[1,1,1];
labor_color=lightBlue*alpha+(1-alpha)*[1,1,1];
cap_color=[0.9500, 0.4250, 0.40]*alpha+(1-alpha)*[1,1,1];

% Set latex as default interpreter
set(groot, 'defaulttextinterpreter','latex'); 
set(groot, 'defaultAxesTickLabelInterpreter','latex'); 
set(groot, 'defaultLegendInterpreter','latex');


% -------------------------------------------------------------------------
%% - Figure 10 and versions thereof -
% -------------------------------------------------------------------------

% - Read data -------------------------------------------------------------

irs_1980_2012 = csvread("irs_clean_1980_2012.csv",2);
irs_1980_2007 = csvread("irs_clean_1980_2007.csv",2);
psz_1980_2012 = csvread("psz_clean_1980_2012.csv",2);
psz_1980_2007 = csvread("psz_clean_1980_2007.csv",2);



% - Figure 10 -------------------------------------------------------------

% - Panel (a): IRS figure -------------------------------------------------
perc = irs_1980_2012(:,1);
growth = irs_1980_2012(:,2);
growth_lab = irs_1980_2012(:,3);
growth_scor = irs_1980_2012(:,4);
growth_cap = irs_1980_2012(:,5);

growth_scor2 = max(growth_lab,0)+growth_scor;
ind_dif = (growth_lab.*growth_scor)<0;
growth_scor2(ind_dif) = growth_scor(ind_dif);

growth_cap2 = growth;
ind_dif = (growth.*growth_cap)<0;
growth_cap2(ind_dif) = growth_cap(ind_dif);

figure_irs = figure('units','centimeters','position',[10 10 10*(16/9) 10]);

axes('Position', [0.06 0.12 .65 .8]);
hold on

h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

legend([h4 h3 h2 h1],{'total income','part due to labor income','part due to 75\% of s-corporations income','part due to capital income'},'Location','NorthWest')
legend('boxoff')
text(92,100*growth(end)+0.05,'Top')
text(92,100*growth(end)-0.3,'0.1\%')
xlim([2 102])
ylim([-1 6])
xlabel('income percentile')
ylabel('annual growth 1980-2012 (in \%)')


axes('Position', [0.75 0.12 .2 .8],'Box','on');
hold on
h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

text(99.65,100*growth(end)+0.05, 'Top')
text(99.65,100*growth(end)-0.3,'0.1\%')
xlim([99 100])
ylim([-1 6])
xlabel('top tail')

set(gcf,'color','w');

export_fig 'output/Figure_paper_consistent_irs_share_1980_2012'.pdf 


% - Panel (b): PSZ figure -------------------------------------------------
perc = psz_1980_2012(:,1);
growth = psz_1980_2012(:,2);
growth_lab = psz_1980_2012(:,5);
growth_scor = psz_1980_2012(:,4);
growth_cap = psz_1980_2012(:,3);

growth_scor2 = max(growth_lab,0)+growth_scor;
ind_dif = (growth_lab.*growth_scor)<0;
growth_scor2(ind_dif) = growth_scor(ind_dif);

growth_cap2 = growth;
ind_dif = (growth.*growth_cap)<0;
growth_cap2(ind_dif) = growth_cap(ind_dif);

figure_irs = figure('units','centimeters','position',[10 10 10*(16/9) 10]);

axes('Position', [0.06 0.12 .65 .8]);
hold on

h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

legend([h4 h3 h2 h1],{'total income','part due to labor income','part due to 75\% of s-corporations income','part due to capital income'},'Location','NorthWest')
legend('boxoff')
text(92,100*growth(end)+0.05,'Top')
text(92,100*growth(end)-0.3,'0.1\%')
xlim([2 102])
ylim([-1 6])
xlabel('income percentile')
ylabel('annual growth 1980-2012 (in \%)')


axes('Position', [0.75 0.12 .2 .8],'Box','on');
hold on
h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

text(99.65,100*growth(end)+0.05, 'Top')
text(99.65,100*growth(end)-0.3,'0.1\%')
xlim([99 100])
ylim([-1 6])
xlabel('top tail')

set(gcf,'color','w');

export_fig 'output/Figure_paper_consistent_psz_share_1980_2012'.pdf 


% - Figure 10 alternative: 1980 - 2007 ------------------------------------

% - Panel (a): IRS figure -------------------------------------------------
perc = irs_1980_2007(:,1);
growth = irs_1980_2007(:,2);
growth_lab = irs_1980_2007(:,3);
growth_scor = irs_1980_2007(:,4);
growth_cap = irs_1980_2007(:,5);

growth_scor2 = max(growth_lab,0)+growth_scor;
ind_dif = (growth_lab.*growth_scor)<0;
growth_scor2(ind_dif) = growth_scor(ind_dif);

growth_cap2 = growth;
ind_dif = (growth.*growth_cap)<0;
growth_cap2(ind_dif) = growth_cap(ind_dif);

figure_irs = figure('units','centimeters','position',[10 10 10*(16/9) 10]);

axes('Position', [0.06 0.12 .65 .8]);
hold on

h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

legend([h4 h3 h2 h1],{'total income','part due to labor income','part due to 75\% of s-corporations income','part due to capital income'},'Location','NorthWest')
legend('boxoff')
text(92,100*growth(end)+0.05,'Top')
text(92,100*growth(end)-0.3,'0.1\%')
xlim([2 102])
ylim([-1 6])
xlabel('income percentile')
ylabel('annual growth 1980-2007 (in \%)')


axes('Position', [0.75 0.12 .2 .8],'Box','on');
hold on
h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

text(99.65,100*growth(end)+0.05, 'Top')
text(99.65,100*growth(end)-0.3,'0.1\%')
xlim([99 100])
ylim([-1 6])
xlabel('top tail')

set(gcf,'color','w');

export_fig 'output/Figure_paper_consistent_irs_share_1980_2007'.pdf 


% - Panel (b): PSZ figure -------------------------------------------------
perc = psz_1980_2007(:,1);
growth = psz_1980_2007(:,2);
growth_lab = psz_1980_2007(:,5);
growth_scor = psz_1980_2007(:,4);
growth_cap = psz_1980_2007(:,3);

growth_scor2 = max(growth_lab,0)+growth_scor;
ind_dif = (growth_lab.*growth_scor)<0;
growth_scor2(ind_dif) = growth_scor(ind_dif);

growth_cap2 = growth;
ind_dif = (growth.*growth_cap)<0;
growth_cap2(ind_dif) = growth_cap(ind_dif);

figure_irs = figure('units','centimeters','position',[10 10 10*(16/9) 10]);

axes('Position', [0.06 0.12 .65 .8]);
hold on

h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

legend([h4 h3 h2 h1],{'total income','part due to labor income','part due to 75\% of s-corporations income','part due to capital income'},'Location','NorthWest')
legend('boxoff')
text(92,100*growth(end)+0.05,'Top')
text(92,100*growth(end)-0.3,'0.1\%')
xlim([2 102])
ylim([-1 6])
xlabel('income percentile')
ylabel('annual growth 1980-2007 (in \%)')


axes('Position', [0.75 0.12 .2 .8],'Box','on');
hold on
h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

text(99.65,100*growth(end)+0.05, 'Top')
text(99.65,100*growth(end)-0.3,'0.1\%')
xlim([99 100])
ylim([-1 6])
xlabel('top tail')

set(gcf,'color','w');

export_fig 'output/Figure_paper_consistent_psz_share_1980_2007'.pdf 


% - Figure 10 alternative: 1980 - 2012 with alternative s-corp -----------

perc = psz_1980_2007(:,1);
growth = psz_1980_2007(:,2);
growth_lab = psz_1980_2007(:,5);
growth_cap = psz_1980_2007(:,6);
growth_scor = psz_1980_2007(:,7);


growth_scor2 = max(growth_lab,0)+growth_scor;
ind_dif = (growth_lab.*growth_scor)<0;
growth_scor2(ind_dif) = growth_scor(ind_dif);

growth_cap2 = growth;
ind_dif = (growth.*growth_cap)<0;
growth_cap2(ind_dif) = growth_cap(ind_dif);

figure_irs = figure('units','centimeters','position',[10 10 10*(16/9) 10]);

axes('Position', [0.06 0.12 .65 .8]);
hold on

h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

legend([h4 h3 h2 h1],{'total income','part due to labor income','part due to 75\% of s-corporations income','part due to capital income'},'Location','NorthWest')
legend('boxoff')
text(92,100*growth(end)+0.05,'Top')
text(92,100*growth(end)-0.3,'0.1\%')
xlim([2 102])
ylim([-1 6])
xlabel('income percentile')
ylabel('annual growth 1980-2007 (in \%)')


axes('Position', [0.75 0.12 .2 .8],'Box','on');
hold on
h1=area(perc,growth_cap2,'Facecolor',cap_color, 'Edgecolor', cap_color);
h2=area(perc,growth_scor2,'Facecolor',scorp_color,'Edgecolor',scorp_color);
h3=area(perc,growth_lab,'Facecolor',labor_color,'Edgecolor',labor_color);
h4=plot(perc,growth,'-.', 'linewidth',1,'color',[0,0,0]);

text(99.65,100*growth(end)+0.05, 'Top')
text(99.65,100*growth(end)-0.3,'0.1\%')
xlim([99 100])
ylim([-1 6])
xlabel('top tail')

set(gcf,'color','w');

export_fig 'output/Figure_paper_consistent_psz_share_1980_2012_alternative'.pdf 
