% -------------------------------------------------------------------------
% Project: Uneven Growth
% Purpose: Create Figure 11
% -------------------------------------------------------------------------

clear variables
close all

cd('C:/Users/Pascual Restrepo/Dropbox/Research/wealth_inequality/AutomationInequality/replication_mrr_january_2021/additional_evidence/capshares_us_data')
addpath 'C:/Users/Pascual Restrepo/Documents/MATLAB/scripts'
addpath 'raw_data'
addpath 'clean_data'
addpath 'output'

% -------------------------------------------------------------------------
%% - Preamble -
% -------------------------------------------------------------------------

% Set latex as default interpreter
set(groot, 'defaulttextinterpreter','latex'); 
set(groot, 'defaultAxesTickLabelInterpreter','latex'); 
set(groot, 'defaultLegendInterpreter','latex');

% -------------------------------------------------------------------------
%% - Figure 11 -
% -------------------------------------------------------------------------

% - Get data --------------------------------------------------------------

us_capshare_data = importdata("capshare_data.csv");
time = us_capshare_data.data(:,1);
us_capshare       = movmean(100*us_capshare_data.data(:,8),5);
us_capshare_adj   = movmean(100*us_capshare_data.data(:,9),5);
us_nipa_capshare     = movmean(100*us_capshare_data.data(:,4),5);
us_nipa_capshare_adj = movmean(100*us_capshare_data.data(:,5),5);
us_wid_top1share     = 100*us_capshare_data.data(:,10);
us_wod_top01share    = 100*us_capshare_data.data(:,11);

% - Figure ----------------------------------------------------------------

figure_us = figure('units','centimeters','position',[10 10 7*(16/9)*2 10]);

subplot(1,2,1)
hold on
h1=plot(time, us_capshare, 'k-', 'LineWidth', 1.2 );
h2=plot(time, us_capshare_adj, 'k--', 'LineWidth', 1.2 );
h3=plot(time, us_nipa_capshare, 'r-', 'LineWidth', 1.2 );
h4=plot(time, us_nipa_capshare_adj, 'r--', 'LineWidth', 1.2 );
set(gcf, 'Color', 'w');
set(gca,'ycolor','k');
title('Panel A. Net capital share in US', 'Interpreter','latex');
ylabel('net capital share, percent', 'Interpreter','latex');
xlim([1949 2019])
ylim([11 31])
legend([h1 h2 h3 h4],{'Piketty, Saez and Zucman (2018)' 'Net of growth' 'Corporate sector, NIPA' 'Net of growth'}, 'location', 'best')
legend('boxoff')

 
subplot(1,2,2)
hold on
h1=plot(time, us_wid_top1share, 'k-', 'LineWidth',1.2);
h2=plot(time, us_wod_top01share, 'r-', 'LineWidth',1.2);
set(gcf, 'Color', 'w');
set(gca,'ycolor','k');
ylabel('income share, percent', 'Interpreter','latex')
title('Panel B. Top income share in the US');
legend([h1 h2],{'Top 1\% income share', 'Top 0.1\% income share'}, 'location', 'best')
legend('boxoff')
xlim([1949 2019])
 
 
export_fig 'output/Figure_paper_us'.pdf