/*

	Project: Unequal Growth
	
	Purpose: Pool together data on capita shares rom NIPA and other sources
	for 1949 onwards
		
*/

clear all
cls

cd "C:\Users\Pascual Restrepo\Dropbox\Research\wealth_inequality\AutomationInequality\replication_mrr_october_2020\additional_evidence\capshares_us_data\"

********************************************************************************
********************************************************************************
* - DATA CONSTRUCTION -
********************************************************************************
********************************************************************************

* ---------------------------------------------------------------------
* - Capital Share and inequality from WID -
* ------------------------------------------------------------------------------

import excel "raw_data/WID_data.xls", firstrow clear
rename Year year
drop if year==.
save clean_data/capshare_data.dta,replace


* ---------------------------------------------------------------------
* - Capital Share from PZ -
* ------------------------------------------------------------------------------

import excel "raw_data/USA.xlsx", sheet("TableUS11") cellrange(A10:Q93) firstrow clear
rename A year
destring Totalcapitalincome, replace force
gen capshare_pz=Totalcapitalincome
keep if year!=.
keep year capshare_pz*
merge 1:1 year using clean_data/capshare_data.dta, nogenerate 
save clean_data/capshare_data.dta,replace

* ---------------------------------------------------------------------
* - Alternative from update by PSZ -
* ------------------------------------------------------------------------------

import excel "raw_data/PSZ2020AppendixTablesI(Aggreg).xlsx", sheet("TSA1") cellrange(A8:Q117) firstrow clear
rename A year
destring Totalcapitalincome, replace force
gen capshare_psz=Totalcapitalincome
keep if year!=.
keep year capshare_psz
merge 1:1 year using clean_data/capshare_data.dta, nogenerate 
save clean_data/capshare_data.dta,replace


* ---------------------------------------------------------------------
* - Corporate Capital Share from NIPA tables -
* ------------------------------------------------------------------------------

import excel raw_data/NIPA_Section1All_xls.xlsx, sheet("T11300-A") cellrange(A8:BV97) clear

keep if inlist(A,"Line","1", "3","4","9")

drop B C

sxpose,clear

* - Get names from lines -
foreach var of varlist * {
	local stub = `var'[1]
	di "`stub'"
	rename `var' nipa1_`stub'
}

drop if _n == 1

foreach var of varlist * {
	destring `var', replace
}

rename nipa1_Line	year

tsset year

gen economy_income=nipa1_1/1000
gen corporate_income=nipa1_3/1000
gen corporate_taxes=nipa1_9/1000
gen corporate_wages=nipa1_4/1000

keep year economy_* corporate_*

merge 1:1 year using clean_data/capshare_data.dta, nogenerate 
save clean_data/capshare_data.dta,replace

* ------------------------------------------------------------------------------
* - Bring data on capital from Fixed-Asset Tables to adjust for growth -
* ------------------------------------------------------------------------------

import excel raw_data/FA_PrivateAssets.xlsx, sheet("Sheet0") cellrange(A6:BV22) clear

keep if inlist(A, "Line","1","2")

sxpose,clear

rename _var1 year
rename _var2 economy_k
rename _var3 corporate_k

destring year, replace force
destring economy_k corporate_k, replace force

drop if year==.
merge 1:1 year using clean_data/capshare_data.dta, nogen keep(3)
save clean_data/capshare_data.dta,replace

import excel raw_data/FA_PrivateAssets_depreciation.xlsx, sheet("Sheet0") cellrange(A6:BV22) clear

keep if inlist(A, "Line","1","2")

sxpose,clear

rename _var1 year
rename _var2 economy_dep
rename _var3 corporate_dep

destring year, replace force
destring economy_dep corporate_dep, replace force

drop if year==.
merge 1:1 year using clean_data/capshare_data.dta, nogen keep(3)
save clean_data/capshare_data.dta,replace


* ------------------------------------------------------------------------------
* - Bring data on growth from CBO -
* ------------------------------------------------------------------------------

import excel raw_data/US_trend_growth.xlsx, sheet("CBO Data") cellrange(A13:C86) clear firstrow
gen year=1959+_n
rename GDPPOT_POPTHM grate
keep year grate

merge 1:1 year using clean_data/capshare_data.dta, nogen keep(2 3)
sort year

* - Impute growth rate of 2.1% per year before 1960 - 
replace grate=2.1 if year<1960
replace grate=grate/100


* - capital-output ratios -
gen economy_ktoy=(economy_k+economy_dep)/economy_income
gen corporate_ktoy=(corporate_k+corporate_dep)/corporate_income

* - net capital share without adjustment -
gen capshare=(corporate_income-corporate_taxes-corporate_wages)/corporate_income

* - net capital share adjusting for g and k-y ratio in corporate sector -
gen capshare_adj=(capshare-grate*corporate_ktoy)/(1-grate*corporate_ktoy)

* - net capital share adjusting for g and k-y ratio in economy -
gen capshare_pz_adj=(capshare_pz-grate*economy_ktoy)/(1-grate*economy_ktoy)

* - net capital share adjusting for g and k-y ratio in economy -
gen capshare_psz_adj=(capshare_psz-grate*economy_ktoy)/(1-grate*economy_ktoy)

* - net capital share adjusting for g and k-y ratio in economy -
gen capshare_wid_adj=(capshare_wid-grate*economy_ktoy)/(1-grate*economy_ktoy)

keep year capshare capshare_pz capshare_pz_adj capshare capshare_adj capshare_psz capshare_psz_adj  capshare_wid capshare_wid_adj top*
order year  capshare_pz capshare_pz_adj capshare capshare_adj capshare_psz capshare_psz_adj capshare_wid capshare_wid_adj top1wid top01wid
export delimited clean_data/capshare_data.csv,replace
erase clean_data/capshare_data.dta
