% -------------------------------------------------------------------------
%
% Project: Uneven Growth
%
% Purpose: Create Figure 11
%
% -------------------------------------------------------------------------

clear variables
close all

cd('C:/Users/Pascual Restrepo/Dropbox/Research/wealth_inequality/AutomationInequality/replication_mrr_january_2021/additional_evidence/capshares_uk_data')
addpath 'C:/Users/Pascual Restrepo/Documents/MATLAB/scripts'
addpath 'raw_data'
addpath 'output'

% -------------------------------------------------------------------------
%% - Preamble -
% -------------------------------------------------------------------------

% Set latex as default interpreter
set(groot, 'defaulttextinterpreter','latex'); 
set(groot, 'defaultAxesTickLabelInterpreter','latex'); 
set(groot, 'defaultLegendInterpreter','latex');

% -------------------------------------------------------------------------
%% - Figure 12 -
% -------------------------------------------------------------------------

% - Get data --------------------------------------------------------------

allen_shares = csvread("capshare_allen.csv",2);
year_capshare=allen_shares(:,1);
data_capshare=100*allen_shares(:,2); % excludes land
data_capshare_inc=100*allen_shares(:,3); % includes land
 
allen_rates = importdata("profit_rate_allen.csv");
year_rates=allen_rates(:,1);
data_rates=100*allen_rates(:,2);
 
allen_wages = importdata("wages_allen.csv");
year_wages=allen_wages(:,1);
data_wages=allen_wages(:,2);
 
lindert_ineq = importdata("top5_lindert.csv");
year_ineq=lindert_ineq(:,1);
data_ineq=lindert_ineq(:,2);

% - Figure ----------------------------------------------------------------

figure_grr = figure('units','centimeters','position',[10 10 7*(16/9)*2 10]);
 
subplot(1,2,1)
hold on
plot(year_capshare, data_capshare_inc, 'k-', 'LineWidth', 1.2)
text(1840,62,'capital share (inc. land)', 'color', 'k');

plot(year_capshare, data_capshare, 'r-', 'LineWidth',1.2);
text(1840,36,'capital share (exc. land)', 'color', 'r');

plot(year_rates, data_rates, 'k--', 'LineWidth', 1.2)
text(1850,14,'return to capital', 'color', 'k');

xticks([1760 1800 1840 1880 1920])
xlim([1760 1920])
ylim([5 65])
title('Panel A. Capital share and returns (Allen, 2009)', 'Interpreter','latex')
xlabel('year', 'Interpreter','latex')
ylabel('percent', 'Interpreter','latex')
set(gcf, 'Color', 'w');
set(gca,'ycolor','k');
 
subplot(1,2,2)
hold on
plot(year_ineq, data_ineq,   'k-', 'LineWidth', 1.2)
text(1830,42,'Top 5\% income share', 'color', 'k');
xlim([1688 1920])
xticks([1720 1760 1800 1840 1880 1920])
ylim([30 45])
title('Panel B. Top income inequality (Lindert, 2000)', 'Interpreter','latex')
xlabel('year', 'Interpreter','latex')
ylabel('percent', 'Interpreter','latex')
set(gcf, 'Color', 'w');
set(gca,'ycolor','k');
 
export_fig 'output/Figure_paper_engel'.pdf